/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.generic;

import ibm.nways.generic.eui.ConfigurationGroup;
import ibm.nways.generic.eui.FaultGroup;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.mib2.eui.SystemGroup;
import ibm.nways.ras.RAS;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.io.Serializable;
import java.util.ResourceBundle;

public class GenericJdm
extends JdmBrowser {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.generic.Resources");
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private static final int RASID = 19;
    private static final int RASSUB = 13;
    static final OID ibmProdOID = new OID("1.3.6.1.4.1.2.6");
    boolean ibmProdBox = false;
    NavigationFolder root;
    GenModel model;
    private NavigationBrowser tree;
    private boolean deviceIsUp;
    private SnmpContextModel contextModel;

    public String getModelTypeName() {
        return "ibm.nways.generic.model.Generic";
    }

    protected synchronized SnmpContextModel getContextModel() {
        String string = "getContextModel";
        SnmpContextModel snmpContextModel = null;
        GenericJdm genericJdm = this;
        synchronized (genericJdm) {
            if (this.contextModel == null) {
                try {
                    this.contextModel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
                }
                catch (Exception exception) {
                    this.contextModel = null;
                    RAS.logException(19, 13, (Object)this, string, exception);
                }
            }
            snmpContextModel = this.contextModel;
        }
        return snmpContextModel;
    }

    public GraphicPanel getDeviceGraphicPanel() {
        String string = "getDeviceGraphicPanel";
        GraphicPanel graphicPanel = null;
        try {
            Image image;
            this.displayMsg(GenericJdm.getNLSString("startGraphic"));
            SnmpContextModel snmpContextModel = this.getContextModel();
            String string2 = snmpContextModel.getSystemIdentifier();
            GraphicContainer graphicContainer = new GraphicContainer();
            if (string2 != null) {
                image = this.imageFrom((Object)this, string2);
                GraphicImage graphicImage = new GraphicImage(image, new Point(19, 0), 1);
                graphicContainer.add((GraphicComponent)graphicImage);
            }
            image = new GraphicHelp((BrowserApplet)this, new Point(0, 5), new HelpRef((Object)this));
            graphicContainer.add((GraphicComponent)image);
            graphicPanel = new GraphicPanel((GraphicHandler)this, (Component)graphicContainer);
            this.displayMsg(GenericJdm.getNLSString("endGraphic"));
        }
        catch (Exception exception) {
            RAS.logException(19, 13, (Object)this, string, exception);
        }
        return graphicPanel;
    }

    private void getInitialDeviceInfo() {
        block9: {
            try {
                ModelInfo modelInfo = this.model.getInfo("Config");
                Serializable serializable = modelInfo.get("Config.SysObjectID");
                if (serializable instanceof Timeout || serializable instanceof NotSupported) {
                    if (RAS.isEnabled(19, 13)) {
                        RAS.trace(19, 13, (Object)this, "getInitialDeviceInfo", "Can't talk to the Device " + serializable.toString());
                    }
                    this.deviceIsUp = false;
                    new BoxDownMsg(this.getFrame(), GenericJdm.getNLSString("genericJDM"));
                    return;
                }
                this.deviceIsUp = true;
                if (!(serializable instanceof OID)) break block9;
                OID oID = new OID(serializable.toString());
                this.ibmProdBox = oID.startsWith(ibmProdOID);
                if (this.ibmProdBox) {
                    if (RAS.isEnabled(19, 13)) {
                        RAS.trace(19, 13, (Object)this, "getInitialDeviceInfo", "Device OID " + serializable.toString() + " is an ibmProd box");
                        return;
                    }
                } else {
                    if (!RAS.isEnabled(19, 13)) break block9;
                    RAS.trace(19, 13, (Object)this, "getInitialDeviceInfo", "Device OID " + serializable.toString() + " is not an ibmProd box");
                }
                return;
            }
            catch (Exception exception) {
                RAS.logException(19, 13, (Object)this, "getInitialDeviceInfo", exception);
                this.deviceIsUp = false;
            }
        }
    }

    protected NavigationPoint getNavTreeRoot() {
        this.displayMsg(GenericJdm.getNLSString("askServer"));
        this.model = (GenModel)this.getModel();
        this.displayMsg(GenericJdm.getNLSString("serverDone"));
        this.getInitialDeviceInfo();
        this.displayMsg(GenericJdm.getNLSString("createNavigationTree"));
        this.root = new NavigationFolder(GenericJdm.getNLSString("generic"));
        return this.root;
    }

    protected void getRestOfNavTree() {
        String string = "getRestOfNavTree";
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.root.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        if (this.deviceIsUp) {
            try {
                GenModel genModel = (GenModel)this.model.getComponent("Configuration");
                ConfigurationGroup configurationGroup = new ConfigurationGroup((JdmBrowser)this, genModel);
                configurationGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationGroup);
                this.root.add((NavigationPoint)configurationGroup);
                NavigationFolder navigationFolder = new NavigationFolder(GenericJdm.getNLSString("SystemFolderGroupTitle"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
                configurationGroup.add((NavigationPoint)navigationFolder);
                this.buildGeneral(navigationFolder);
            }
            catch (Exception exception) {
                RAS.logException(19, 13, (Object)this, string, exception);
            }
            this.buildFault(this.root);
        } else {
            NavigationFolder navigationFolder = new NavigationFolder(GenericJdm.getNLSString("ConfigurationFolderGroupTitle"));
            this.root.add((NavigationPoint)navigationFolder);
            NavigationFolder navigationFolder2 = new NavigationFolder(GenericJdm.getNLSString("SystemFolderGroupTitle"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder.add((NavigationPoint)navigationFolder2);
            NavigationFolder navigationFolder3 = new NavigationFolder(GenericJdm.getNLSString("SystemGeneralGroupTitle"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder2.add((NavigationPoint)navigationFolder3);
            SnmpContextModel snmpContextModel = this.getContextModel();
            navigationFolder3.add((NavigationPoint)new NavigationItem(GenericJdm.getNLSString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", (RemoteModel)snmpContextModel), "SnmpConfig"));
            navigationFolder3.add((NavigationPoint)new NavigationItem(GenericJdm.getNLSString("perfConfig"), new NavigationDestination("ibm.nways.analysis.dpManager.Admin.DpAdminDestinationPanel", (RemoteModel)snmpContextModel), "PerfConfig"));
            NavigationItem navigationItem = new NavigationItem(GenericJdm.getNLSString("CommunicationsFolderGroupTitle"), (NavigationDestination)new MessageDestination(GenericJdm.getNLSString("notConfigured")));
            navigationFolder.add((NavigationPoint)navigationItem);
            this.root.add((NavigationPoint)new NavigationItem(GenericJdm.getNLSString("FaultGroupTitle"), (NavigationDestination)new MessageDestination(GenericJdm.getNLSString("notConfigured"))));
        }
        this.buildTools(this.root);
        this.displayMsg(GenericJdm.getNLSString("initDone"));
    }

    private void buildGeneral(NavigationFolder navigationFolder) {
        String string = "buildGeneral";
        try {
            GenModel genModel = (GenModel)this.model.getComponent("System");
            if (genModel != null) {
                SystemGroup systemGroup = new SystemGroup((JdmBrowser)this, genModel);
                systemGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)systemGroup);
                navigationFolder.add((NavigationPoint)systemGroup);
                SnmpContextModel snmpContextModel = this.getContextModel();
                systemGroup.add((NavigationPoint)new NavigationItem(GenericJdm.getNLSString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", (RemoteModel)snmpContextModel), "SnmpConfig"));
                systemGroup.add((NavigationPoint)new NavigationItem(GenericJdm.getNLSString("perfConfig"), new NavigationDestination("ibm.nways.analysis.dpManager.Admin.DpAdminDestinationPanel", (RemoteModel)snmpContextModel), "PerfConfig"));
                return;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 13, (Object)this, string, exception);
        }
    }

    private void buildFault(NavigationFolder navigationFolder) {
        String string = "buildFault";
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.model.getComponent("Traps");
        }
        catch (Exception exception) {
            RAS.logException(19, 13, (Object)this, string, exception);
        }
        if (genModel != null) {
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, genModel);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            navigationFolder.add((NavigationPoint)faultGroup);
            return;
        }
        navigationFolder.add((NavigationPoint)new NavigationItem(GenericJdm.getNLSString("FaultGroupTitle"), (NavigationDestination)new MessageDestination(GenericJdm.getNLSString("NotConfigured"))));
    }

    private void buildTools(NavigationFolder navigationFolder) {
        String string = "buildTools";
        NavigationContext navigationContext = null;
        NavigationFolder navigationFolder2 = new NavigationFolder(GenericJdm.getNLSString("ToolsGroupTitle"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            SnmpContextModel snmpContextModel = this.getContextModel();
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string2 = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string2);
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            Browser browser = new Browser("MIB Browser", (JdmBrowser)this, snmpContextModel);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ibm.nways.web.Resources");
            WebContext webContext = new WebContext(string2);
            if (this.ibmProdBox) {
                webContext.support_and_device();
            } else {
                webContext.device_only();
            }
            NavigationItem navigationItem2 = new NavigationItem(resourceBundle2.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem2.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem2);
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string2, this.getServerPortNumber());
                NavigationItem navigationItem3 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem3.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem3);
                return;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 13, (Object)this, string, exception);
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = commonResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
            }
        }
        return string2;
    }
}

